/*global define */
/*jslint white: true */

/*
	AudioContainer:

	This object provides a mixin for each audio container.
*/

define(["src/build/AudioClip", "src/utils", "src/build/TimeItem", "src/build/treeContainer"],
function (AudioClip, utils, TimeItem, treeContainer) {
	'use strict';

	var AudioClip_clone = AudioClip.prototype.clone;

	function AudioContainer(inName, inPlayASAP) {
		this.AudioClip("AudioContainer", inName, inPlayASAP);
		this.m_children = [];
	}


	utils.mixin(AudioContainer,
		AudioClip, 
		treeContainer({
		childrenLabel: "m_children"
		}),
		{
			clone: function (clone_children, other) {
				var i, ci,
					result = other;

				if (result) {
					// init
					AudioContainer.call(result);
				} else {
					// alloc and init
					result = new AudioContainer();
				}

				// clone node state
					AudioClip_clone.call(this, clone_children, result);

				// copy (by default) container children...
				if (clone_children === undefined || clone_children) {
					this.m_children = [];
					for (i = 0; i < this.m_children.length; i += 1) {
						ci = this.m_children[i];
						ci = ci.clone(clone_children);
						result.m_children[i] = ci;
						ci.setParent(result);
					}
				}

				return result;
			},

			setEnabledChildren: function (enabled) {
				var c;
				for (c = 0; c < this.m_children.length; c += 1) {
					this.m_children[c].setEnabled(enabled);
				}
			},
		
			removeChangeNotifiers: function () {
				var c;
				for (c = 0; c < this.m_children.length; c += 1) {
					this.m_children[c].removeChangeNotifiers();
				}
				this.removeAllChangeNotifiers();
			}
		}
	);


	return AudioContainer;
});
